<?php

/**
 * This is the model class for table "RodzajKampanii".
 *
 * The followings are the available columns in table 'RodzajKampanii':
 * @property double $id
 * @property string $nazwa
 */
class RodzajKampanii extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return RodzajKampanii the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'RodzajKampanii';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('nazwa', 'length', 'max'=>128),

			array('id, nazwa', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'kampanies'=>array(self::HAS_MANY, 'Kampanie', 'idRodzajKampanii'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('RodzajKampanii', 'id'),
			'nazwa'=>Yii::t('RodzajKampanii', 'nazwa'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('nazwa', $this->nazwa, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}